/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.TypeConverter;

public class ErrorDataBlock
extends DataBlock {
    protected Integer errorID;
    protected String errorDescr;
    protected static final String[][] errorArray = new String[][]{{"Dummy Error Event", "This event is generated by program code to test the packet parsing subroutines.  It does not represent an actual error."}};

    public ErrorDataBlock(Integer[] integerArray) {
        this.errorID = (int)TypeConverter.composeLong(integerArray, 7);
        int n = (int)TypeConverter.composeLong(integerArray, 11);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray[i + 15];
            stringBuffer.append(String.format("%c", n2));
        }
        this.errorDescr = stringBuffer.toString();
    }

    public boolean isError() {
        return true;
    }

    public String getType() {
        return this.errorID.toString();
    }

    public String getSummary() {
        if (this.errorID < errorArray.length) {
            return errorArray[this.errorID][0];
        }
        return this.errorDescr;
    }

    public String getDetails() {
        if (this.errorID < errorArray.length) {
            return errorArray[this.errorID][1];
        }
        return "" + this.errorID.toString() + ": " + this.errorDescr;
    }

    public String getDirection() {
        return "ERROR";
    }

    public short getSource() {
        return 4;
    }

    public String getSourceName() {
        return "Error";
    }

    public long getTimestamp() {
        return 0L;
    }

    public boolean isEvent() {
        return false;
    }

    public boolean isI2C() {
        return false;
    }

    public boolean isCEC() {
        return false;
    }

    public boolean isHDCP() {
        return false;
    }

    public boolean isDDCCI() {
        return false;
    }

    public boolean isEDID() {
        return false;
    }

    public boolean isLT() {
        return false;
    }

    public int getSourceID() {
        return 0;
    }
}

